/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UBJsonWriter
implements Closeable {
    final DataOutputStream out;
    private JsonObject current;
    private boolean named;
    private final Array<JsonObject> stack = new Array();

    public UBJsonWriter(OutputStream out) {
        if (!(out instanceof DataOutputStream)) {
            out = new DataOutputStream(out);
        }
        this.out = (DataOutputStream)out;
    }

    public UBJsonWriter object() throws IOException {
        if (this.current != null && !this.current.array) {
            if (!this.named) {
                throw new IllegalStateException("Name must be set.");
            }
            this.named = false;
        }
        this.current = new JsonObject(false);
        this.stack.add(this.current);
        return this;
    }

    public UBJsonWriter object(String name) throws IOException {
        this.name(name).object();
        return this;
    }

    public UBJsonWriter array() throws IOException {
        if (this.current != null && !this.current.array) {
            if (!this.named) {
                throw new IllegalStateException("Name must be set.");
            }
            this.named = false;
        }
        this.current = new JsonObject(true);
        this.stack.add(this.current);
        return this;
    }

    public UBJsonWriter array(String name) throws IOException {
        this.name(name).array();
        return this;
    }

    public UBJsonWriter name(String name) throws IOException {
        if (this.current == null || this.current.array) {
            throw new IllegalStateException("Current item must be an object.");
        }
        byte[] bytes2 = name.getBytes("UTF-8");
        if (bytes2.length <= 127) {
            this.out.writeByte(105);
            this.out.writeByte(bytes2.length);
        } else if (bytes2.length <= Short.MAX_VALUE) {
            this.out.writeByte(73);
            this.out.writeShort(bytes2.length);
        } else {
            this.out.writeByte(108);
            this.out.writeInt(bytes2.length);
        }
        this.out.write(bytes2);
        this.named = true;
        return this;
    }

    public UBJsonWriter value(byte value2) throws IOException {
        this.checkName();
        this.out.writeByte(105);
        this.out.writeByte(value2);
        return this;
    }

    public UBJsonWriter value(short value2) throws IOException {
        this.checkName();
        this.out.writeByte(73);
        this.out.writeShort(value2);
        return this;
    }

    public UBJsonWriter value(int value2) throws IOException {
        this.checkName();
        this.out.writeByte(108);
        this.out.writeInt(value2);
        return this;
    }

    public UBJsonWriter value(long value2) throws IOException {
        this.checkName();
        this.out.writeByte(76);
        this.out.writeLong(value2);
        return this;
    }

    public UBJsonWriter value(float value2) throws IOException {
        this.checkName();
        this.out.writeByte(100);
        this.out.writeFloat(value2);
        return this;
    }

    public UBJsonWriter value(double value2) throws IOException {
        this.checkName();
        this.out.writeByte(68);
        this.out.writeDouble(value2);
        return this;
    }

    public UBJsonWriter value(boolean value2) throws IOException {
        this.checkName();
        this.out.writeByte(value2 ? 84 : 70);
        return this;
    }

    public UBJsonWriter value(char value2) throws IOException {
        this.checkName();
        this.out.writeByte(73);
        this.out.writeChar(value2);
        return this;
    }

    public UBJsonWriter value(String value2) throws IOException {
        this.checkName();
        byte[] bytes2 = value2.getBytes("UTF-8");
        this.out.writeByte(83);
        if (bytes2.length <= 127) {
            this.out.writeByte(105);
            this.out.writeByte(bytes2.length);
        } else if (bytes2.length <= Short.MAX_VALUE) {
            this.out.writeByte(73);
            this.out.writeShort(bytes2.length);
        } else {
            this.out.writeByte(108);
            this.out.writeInt(bytes2.length);
        }
        this.out.write(bytes2);
        return this;
    }

    public UBJsonWriter value(byte[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(105);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeByte(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(short[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(73);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeShort(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(int[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(108);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeInt(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(long[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(73);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeLong(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(float[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(100);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeFloat(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(double[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(100);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeDouble(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(boolean[] values2) throws IOException {
        this.array();
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeByte(values2[i] ? 84 : 70);
        }
        this.pop();
        return this;
    }

    public UBJsonWriter value(char[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(73);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeChar(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(String[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(83);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            byte[] bytes2 = values2[i].getBytes("UTF-8");
            if (bytes2.length <= 127) {
                this.out.writeByte(105);
                this.out.writeByte(bytes2.length);
            } else if (bytes2.length <= Short.MAX_VALUE) {
                this.out.writeByte(73);
                this.out.writeShort(bytes2.length);
            } else {
                this.out.writeByte(108);
                this.out.writeInt(bytes2.length);
            }
            this.out.write(bytes2);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(JsonValue value2) throws IOException {
        if (value2.isObject()) {
            if (value2.name != null) {
                this.object(value2.name);
            } else {
                this.object();
            }
            JsonValue child = value2.child;
            while (child != null) {
                this.value(child);
                child = child.next;
            }
            this.pop();
        } else if (value2.isArray()) {
            if (value2.name != null) {
                this.array(value2.name);
            } else {
                this.array();
            }
            JsonValue child = value2.child;
            while (child != null) {
                this.value(child);
                child = child.next;
            }
            this.pop();
        } else if (value2.isBoolean()) {
            if (value2.name != null) {
                this.name(value2.name);
            }
            this.value(value2.asBoolean());
        } else if (value2.isDouble()) {
            if (value2.name != null) {
                this.name(value2.name);
            }
            this.value(value2.asDouble());
        } else if (value2.isLong()) {
            if (value2.name != null) {
                this.name(value2.name);
            }
            this.value(value2.asLong());
        } else if (value2.isString()) {
            if (value2.name != null) {
                this.name(value2.name);
            }
            this.value(value2.asString());
        } else if (value2.isNull()) {
            if (value2.name != null) {
                this.name(value2.name);
            }
            this.value();
        } else {
            throw new IOException("Unhandled JsonValue type");
        }
        return this;
    }

    public UBJsonWriter value(Object object) throws IOException {
        if (object == null) {
            return this.value();
        }
        if (object instanceof Number) {
            Number number2 = (Number)object;
            if (object instanceof Byte) {
                return this.value(number2.byteValue());
            }
            if (object instanceof Short) {
                return this.value(number2.shortValue());
            }
            if (object instanceof Integer) {
                return this.value(number2.intValue());
            }
            if (object instanceof Long) {
                return this.value(number2.longValue());
            }
            if (object instanceof Float) {
                return this.value(number2.floatValue());
            }
            if (object instanceof Double) {
                return this.value(number2.doubleValue());
            }
        } else {
            if (object instanceof Character) {
                return this.value(((Character)object).charValue());
            }
            if (object instanceof CharSequence) {
                return this.value(object.toString());
            }
            throw new IOException("Unknown object type.");
        }
        return this;
    }

    public UBJsonWriter value() throws IOException {
        this.checkName();
        this.out.writeByte(90);
        return this;
    }

    public UBJsonWriter set(String name, byte value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, short value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, int value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, long value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, float value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, double value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, boolean value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, char value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, String value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, byte[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, short[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, int[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, long[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, float[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, double[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, boolean[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, char[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name, String[] value2) throws IOException {
        return this.name(name).value(value2);
    }

    public UBJsonWriter set(String name) throws IOException {
        return this.name(name).value();
    }

    private void checkName() {
        if (this.current != null && !this.current.array) {
            if (!this.named) {
                throw new IllegalStateException("Name must be set.");
            }
            this.named = false;
        }
    }

    public UBJsonWriter pop() throws IOException {
        return this.pop(false);
    }

    protected UBJsonWriter pop(boolean silent) throws IOException {
        if (this.named) {
            throw new IllegalStateException("Expected an object, array, or value since a name was set.");
        }
        if (silent) {
            this.stack.pop();
        } else {
            this.stack.pop().close();
        }
        this.current = this.stack.size == 0 ? null : this.stack.peek();
        return this;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size > 0) {
            this.pop();
        }
        this.out.close();
    }

    private class JsonObject {
        final boolean array;

        JsonObject(boolean array) throws IOException {
            this.array = array;
            UBJsonWriter.this.out.writeByte(array ? 91 : 123);
        }

        void close() throws IOException {
            UBJsonWriter.this.out.writeByte(this.array ? 93 : 125);
        }
    }
}

